' VB Script to remove ACE on File System and Active Directory objects        '
'                                                                            '
' Version 1.00 - Alain Lissoir                                               '
' Compaq Computer Corporation - Professional Services - Belgium -            '
'                                                                            '
' Any comments or questions:                  EMail:alain.lissoir@compaq.com '

Option Explicit

' -------------------------------------------------------------------------------------------------------------------------
Public Sub RemoveRights(strObject, strTrustee, strObjectType)

        Dim objSecurity
        Dim objADObject
        Dim objSD
        Dim objDACL
        Dim objACE
        Dim objNewACE
        Dim objRemoveACE

        Select Case strObjectType
               Case FS_OBJECT
                    Set objSecurity = CreateObject("ADsSecurity")
                    Set objSD = objSecurity.GetSecurityDescriptor("FILE://" & strObject)
               Case AD_OBJECT
                    Set objADObject = GetObject("LDAP://" & strObject)
                    Set objSD = objADObject.Get("ntSecurityDescriptor")
               Case Else
                    Exit Sub
        End Select

        Set objDACL = objSD.DiscretionaryAcl

        For Each objACE In objDACL
            Select Case strTrustee
                   Case "REMOVE_ALL_RIGHTS"
                           objDACL.RemoveAce (objACE)

                   Case Else
                        If (objACE.Trustee = strTrustee) Then
                           Wscript.Echo "  Trustee '" & strTrustee & _
                                        "' has been removed from '" & strObject & "'"
                           objDACL.RemoveAce (objACE)

                           Exit For
                        End If
            End Select
        Next

        If strTrustee = "REMOVE_ALL_RIGHTS" Then
           Set objNewACE = CreateObject("AccessControlEntry")

           ' Add the new Trustee with his specific rights
           objNewACE.Trustee = "Everyone"
           objNewACE.AceType = ADS_ACETYPE_ACCESS_ALLOWED
           objNewACE.AccessMask = ADS_RIGHT_GENERIC_ALL
           objNewACE.AceFlags = CONTAINER_INHERIT_ACE Or OBJECT_INHERIT_ACE

           Wscript.Echo "  All rights are removed, Trustee '" & objNewACE.Trustee & _
                        "' (Full Control) has been added."

           objDACL.AddAce objNewACE

           WScript.DisconnectObject objNewACE
           Set objNewACE = Nothing
        End If

        objSD.DiscretionaryAcl = objDACL

        Select Case strObjectType
               Case FS_OBJECT
                    objSecurity.SetSecurityDescriptor objSD
                    WScript.DisconnectObject objSecurity
                    Set objSecurity = Nothing
               Case AD_OBJECT
                    objADObject.Put "ntSecurityDescriptor", objSD
                    objADObject.SetInfo
                    WScript.DisconnectObject objADObject
                    Set objADObject = Nothing
        End Select

        Set objDACL = Nothing
        Set objSD = Nothing

End Sub